#!/bin/bash

version="Alpha0.6.12"
current_dir=$(cd `dirname $0`; pwd)
file_name="runApp.sh"

export LD_LIBRARY_PATH=$current_dir/lib:$LD_LIBRARY_PATH
export QT_PLUGIN_PATH=$current_dir/plugins:$QT_PLUGIN_PATH
export QML2_IMPORT_PATH=$current_dir/qml:$QML2_IMPORT_PATH
export QTWEBENGINE_DISABLE_SANDBOX=1

desktop_path="$current_dir/transmart.desktop"

createDesktop(){
    echo "[Desktop Entry]" >> $desktop_path
    echo "Type=Application" >> $desktop_path
    echo "Version=$version" >> $desktop_path
    echo "Name=TranSmart.desktop" >> $desktop_path
    echo "Exec='$current_dir/$file_name' %F" >> $desktop_path
    echo "Icon=$current_dir/logo.png" >> $desktop_path
    echo "Comment=Tencent TranSmart" >> $desktop_path
    echo "Terminal=false" >> $desktop_path
    echo "MimeType=x-scheme-handler/transmart" >> $desktop_path
    echo "Categories=Utility;Application" >> $desktop_path
    chmod +x $desktop_path
    cp $desktop_path ~/.local/share/applications/transmart.desktop -f
}

if [ -f "$desktop_path" ];then
    if [ ! `grep -c "$current_dir/$file_name" $desktop_path` -ne '0' ];then
        rm $desktop_path
        createDesktop
    fi
else
    createDesktop
fi

$current_dir/TranSmart

